local unitArea = math.pi * 3/4
local sizeRatio = math.sqrt(4 / unitArea)

StrokedCirclePointStamp = function(canvas, x, y, radius, paint)
    local size = (radius or 2) * sizeRatio
    local path = Path.oval{
        left = x - size * 3/4,
        bottom = y - size * 3/4,
        right = x + size * 3/4,
        top = y + size * 3/4,
    }
    canvas:setPaint(paint):setThickness(size / 2):stroke(path)
end

return StrokedCirclePointStamp
